from axelrod.action import Action

from axelrod.player import Player

C, D = Action.C, Action.D

class GrudgerAlternator(Player):
    """
    A player starts by cooperating until the first opponents defection,
    then alternates D-C.

    Names:

    - c_then_per_dc: [Prison1998]_
    - Grudger Alternator: Original name by Geraint Palmer
    """

    name = "GrudgerAlternator"
    classifier = {
        "memory_depth": float("inf"),  # Long memory
        "stochastic": False,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def strategy(self, opponent: Player) -> Action:
        """Begins by playing C, then plays Alternator for the remaining rounds
        if the opponent ever plays D."""
        if opponent.defections:
            if self.history[-1] == C:
                return D
        return C